using Server.ContextMenus;
using Server.Network;
using Server.Targeting;
using System;
using System.Collections;
using System.Collections.Generic;

namespace Server.Items
{
    public class ArcanumIgnis : NecromancerSpellbook
    {
        // 		public override int ArtifactRarity{ get{ return 75; } }

        [Constructable]
        public ArcanumIgnis() : base((UInt64)0xFFFF)
        {
            Hue = 2162;
            Name = "<basefont color=#FF6600>Arcanum Ignis";

            SkillBonuses.SetValues(0, SkillName.Magery, 20.0);
            SkillBonuses.SetValues(1, SkillName.Necromancy, 10.0);
            SkillBonuses.SetValues(2, SkillName.Spellweaving, 10.0);
            Attributes.SpellDamage = 60;
            Attributes.DefendChance = 30;
            Attributes.Luck = 180;
            Attributes.BonusInt = 35;
            Attributes.EnhancePotions = 25;
            Attributes.LowerManaCost = 15;
            Attributes.LowerRegCost = 35;
            Attributes.RegenMana = 6;
            Attributes.BonusMana = 20;
            Attributes.CastSpeed = 2;
            Attributes.CastRecovery = 3;
            Slayer = SlayerName.SpidersDeath;
        }

        public override void GetProperties(ObjectPropertyList list)
        {
            base.GetProperties(list);

            list.Add("<basefont color=#FF6600>Summon Fire Fury\nFire Blast Spell<basefont color=White>");
        }

        public override void OnDoubleClick(Mobile from)
        {
            if (this.BlessedFor == null && this.RootParent == from)
                this.BlessedFor = from;

            base.OnDoubleClick(from);
        }

        private bool CheckUse(Mobile from)
        {
            if (!this.IsAccessibleTo(from))
                return false;

            if (this.BlessedFor != from || this.RootParent != from)
            {
                from.SendMessage("Musis mit knihu u sebe");
                return false;
            }

            if (!from.CanBeginAction(typeof(ArcanumIgnis)))
            {
                from.SendLocalizedMessage(1049615); // You must take a moment to catch your breath.
                return false;
            }

            return true;
        }

        private class LookAtEntry : ContextMenuEntry
        {
            private ArcanumIgnis m_Book;
            private Mobile m_From;

            public LookAtEntry(ArcanumIgnis book, Mobile from) : base(6170, 1)
            {
                m_Book = book;
                m_From = from;
            }

            public override void OnClick()
            {
                if (m_Book.CheckUse(m_From))
                {
                    m_From.SendLocalizedMessage(1049620); // Select an area to incinerate.
                    m_From.Target = new InternalTarget(m_Book);
                }
            }
        }

        public override void GetContextMenuEntries(Mobile from, List<ContextMenuEntry> list)
        {
            if (CheckUse(from))
            {
                list.Add(new LookAtEntry(this, from));
            }

            base.GetContextMenuEntries(from, list);
        }

        private static void EndAction(object state)
        {
            Mobile m = (Mobile)state;

            m.EndAction(typeof(ArcanumIgnis));
            //m.SendLocalizedMessage( 1049621 ); // You catch your breath.
        }

        private class InternalTarget : Target
        {
            private ArcanumIgnis m_ArcanumIgnis;

            public InternalTarget(ArcanumIgnis book) : base(8, true, TargetFlags.Harmful)
            {
                m_ArcanumIgnis = book;
            }

            protected override void OnTarget(Mobile from, object targeted)
            {
                if (m_ArcanumIgnis.Deleted)
                    return;

                IPoint3D loc;
                if (targeted is Item)
                    loc = ((Item)targeted).GetWorldLocation();
                else
                    loc = targeted as IPoint3D;

                m_ArcanumIgnis.Use(from, loc);
            }
        }

        public void Use(Mobile from, IPoint3D loc)
        {
            if (!CheckUse(from))
                return;

            from.BeginAction(typeof(ArcanumIgnis));

            if (from.Backpack.ConsumeTotal(typeof(ArcaneDust), 1, false))
            {
                Timer.DelayCall(TimeSpan.FromSeconds(1.0), new TimerStateCallback(EndAction), from);
            }
            else
            {
                Timer.DelayCall(TimeSpan.FromMinutes(5.0), new TimerStateCallback(EndAction), from);
            }

            /*int sucChance = ( 500 + ( from.Skills[SkillName.Necromancy].Fixed - 1200 ) ) * 2;

			if ( ( ((double)sucChance) / 1000.0 ) > Utility.RandomDouble() )
			{
				from.SendMessage( "Kouzlo se nepodarilo vyvolat" );
				from.PlaySound( 0x18A );
				return;
			}*/

            from.PlaySound(0x15F);
            from.RevealingAction();
            Effects.SendPacket(from, from.Map, new HuedEffect(EffectType.Moving, from.Serial, Serial.Zero, 0x36D4, from.Location, loc, 5, 0, false, true, 0, 0));

            ArrayList targets = new ArrayList();

            IPooledEnumerable eable = from.Map.GetMobilesInRange(new Point3D(loc), 4);

            foreach (Mobile m in eable)
            {
                if (from != m && Spells.SpellHelper.ValidIndirectTarget(from, m) && from.CanBeHarmful(m, false))
                {
                    if (!from.InLOS(m) || m.Hits < (m.HitsMax * 0.90)) //pouze monstra nad 90% zivota
                        continue;

                    targets.Add(m);
                }
            }

            eable.Free();

            if (targets.Count > 0)
            {
                for (int i = 0; i < targets.Count; ++i)
                {
                    Timer.DelayCall(TimeSpan.FromSeconds((((double)i) + 1.0) * 0.5), new TimerStateCallback(TriggerDamage), new object[] { from, (Mobile)targets[i] });

                    //Effects.SendTargetEffect(m, 0x3709, 10, 30);
                }
            }
        }

        private static void TriggerDamage(object state)
        {
            object[] args = (object[])state;
            Mobile attacker = (Mobile)args[0];
            Mobile defender = (Mobile)args[1];

            if (defender == null || defender.Deleted || !defender.Alive || attacker == null || attacker.Deleted || !attacker.Alive)
                return;

            if (defender is Mobiles.DrakAuberon)
            {
                defender.Say("Opravdu si myslis, ze mne kouzlo Fire blast muze zranit?");
                return;
            }

            Effects.SendMovingParticles(
                                new Entity(Serial.Zero, new Point3D(defender.X, defender.Y, defender.Z + 90), defender.Map),
                                new Entity(Serial.Zero, defender.Location, defender.Map),
                                0x36D4, 5, 0, false, false, 0, 0, 9502, 1, 0, (EffectLayer)255, 0x100);

            Effects.PlaySound(defender.Location, defender.Map, 0x11D);

            attacker.DoHarmful(defender);
            int auradamage = Engines.XmlSpawner2.XmlSpecial.PercentualDamage(Utility.RandomMinMax(15, 20), defender);

            defender.Hits -= auradamage;
            defender.SendDamageToAll(auradamage);

            if (defender.Hits < 2)
                defender.Kill();
        }

        public ArcanumIgnis(Serial serial) : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
        }
    }
}

